#Proyecto 6. Snake básico

Como verás, el tablero inicial muestra algunas bolitas rojas (siempre en la misma posición) 
que representan manzanas. El objetivo de la actividad es que dibujes una serie de bolitas verdes, 
que representen a una víbora avanzando hasta cada una de las “manzanas” donde se las “come” 
(o sea, saca la bolita roja). Las manzanas se pueden comer en cualquier orden. 
La víbora no puede pasar por encima de ella misma; es decir, no puede pasar por lugares que ya 
tengan una bolita verde.
El tablero inicial se muestra en la siguiente imagen. 
Tené en cuenta que el cabezal siempre empieza en la esquina suroeste:

<center>
![Tablero inicial](data:image/png;base64,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)
</center>

Algunos posibles tableros finales se muestran en las imágenes siguientes. 
La variación está en el orden en que se comieron las manzanas. 
Tu programa debería producir un tablero final que coma todas las manzanas, y que podría ser 
uno de los que se muestran u otros diferentes. 
¿Te atrevés a conseguir uno que no sea de los que se muestran?

<center>
![Algunos tableros finales posibles](data:image/png;base64,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)
</center>

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/1.Descubrir%20Gobstones/6.Snake%20b%C3%A1sico/assets/resources/description.pdf "Enunciado de 'Snake básico' en PDF"

